<?php
/**
 * @author Florian Hochriegl, Florian@Hochriegl.de
 * @website www.gamers-congress.de
 * @version 2011033001
 * Notwendige Konfigurationsparameter fr's Bezahlscript
 */

// Event ID + Name des aktuellen Events. Knnte theoretisch auch aus der Datenbank ausgelesen werden
$GCeventID = 14;
$GCName = "GSH 22"; // Keine Sonderzeichen verwenden!!!


// Notwendige Links + Mailadresse fr die PayPal Konfiguration
$paypalConfig['cancel_return']= "http://www.gsh-lan.com/payment/return_cancel.php";
$paypalConfig['notify_url']=    "http://www.gsh-lan.com/payment/paypal_ipn.php";
$paypalConfig['return']=        "http://www.gsh-lan.com/payment/return_ok.php";
$paypalConfig['emailadress']=   "info@gsh-lan.com";

// Notwendige Daten fr die berweisung
$bankverbindung['empfaenger_name'] = "";
$bankverbindung['empfaenger_kontonr'] = "";
$bankverbindung['empfaenger_blz'] = "";
$bankverbindung['empfaenger_bankname'] = "";
$bankverbindung['empfaenger_bic'] = "";
$bankverbindung['empfaenger_iban'] = "";

/**
 * Definition der Sitzplatzdaten, dabei sind folgende Eigenschaften zulssig:
 * ArrayEbene 1 = Name des Sitzplatzbereichs (z.B. VIP oder Parkett)
 * ArrayEbene 2 = Optionen
 *
 * ArrayEbene 1:
 * ['price'] = "30"                 | Preis in ?
 * ['price_style'] = "fixed"        | muss fixed sein
 *
 * oder:
 * ['price']['11'] = 15             | 12 Eintragungen, fr Staffelpreise je nach Monat! Preis in ?
 * ['price_style'] = "per_month"    | muss per_month sein
 *
 * ArrayEbene 2:
 * ['visible'] = true               | Ist die eintragung momentan aktiv / sichtbar zum auswhlen? true oder false
 * ['include'][0] = "Kaffeflat";    | Gibts Features kostenfrei dazu? / die Option MUSS auch als Option angelegt sein!
 * ['event_status'] = 7;            | Sitzplatzstatus! Kann in der Datenbank unter event_status abgelesen werden!
 *
 */

$seats['Standardplatz']['price'] = "15";
$seats['Standardplatz']['price_style'] = "fixed";
$seats['Standardplatz']['visible'] = true;
$seats['Standardplatz']['event_status'] = 2;

$seats['Gigabit-Platz']['price'] = "25";
$seats['Gigabit-Platz']['price_style'] = "fixed";
$seats['Gigabit-Platz']['visible'] = true;
$seats['Gigabit-Platz']['event_status'] = 12;

/**
 * Definition der Optionen!
 * ArrayEbene 1 = Name der Option (z.B. Kaffeeflat)
 * ArrayEbene 2 = Optionen
 *
 * ['price'] = "5";                     | Kosten
 * ['price_style'] = "additional";      | additional = wird einfach dazugezhlt, percent = wird in % zum Betrag addiert, MUSS dann am Ende stehen
 * ['visible'] = true;                  | ist die Option derzeit sichtbar?
 * ['required'] = true;                 | ist die Option verpflichtent? -> ist sichtbar, aber kann nicht abgewhlt werden
 * ['add_to_user_comment'] = true;      | soll beim Buchen ein Eintrag im User-Kommentarfeld hinterlegt werden?
 */

$options['Platzhalter']['price'] = "0";
$options['Platzhalter']['price_style'] = "additional";
$options['Platzhalter']['visible'] = false;
$options['Platzhalter']['required'] = false;
$options['Platzhalter']['add_to_user_comment'] = false;

// WICHTIG: Muss ganz am Ende stehen!!!!
//$options['Paypal Gebhren']['price'] = "0.06";
//$options['Paypal Gebhren']['price_style'] = "percent";
//$options['Paypal Gebhren']['visible'] = true;
//$options['Paypal Gebhren']['required'] = true;
//$options['Paypal Gebhren']['add_to_user_comment'] = false;
?>
