<?php
/**
 * @author Florian Hochriegl, Florian@Hochriegl.de
 * @website www.gamers-congress.de
 * @version 2011033001
 * Notwendige Konfigurationsparameter fr's Bezahlscript
 */

// Event ID + Name des aktuellen Events. Knnte theoretisch auch aus der Datenbank ausgelesen werden
$GCeventID = 9;
$GCName = "XXX"; // Keine Sonderzeichen verwenden!!!


// Notwendige Links + Mailadresse fr die PayPal Konfiguration
$paypalConfig['cancel_return']= "http://XXX/gc_payment/return_cancel.php";
$paypalConfig['notify_url']=    "http://XXX/paypal_ipn.php";
$paypalConfig['return']=        "http://XXX/return_ok.php";
$paypalConfig['emailadress']=   "XXX";

// Notwendige Daten fr die berweisung
$bankverbindung['empfaenger_name'] = "XXX";
$bankverbindung['empfaenger_kontonr'] = "XXX";
$bankverbindung['empfaenger_blz'] = "XXX";
$bankverbindung['empfaenger_bankname'] = "XXX";

/**
 * Definition der Sitzplatzdaten, dabei sind folgende Eigenschaften zulssig:
 * ArrayEbene 1 = Name des Sitzplatzbereichs (z.B. VIP oder Parkett)
 * ArrayEbene 2 = Optionen
 *
 * ArrayEbene 1:
 * ['price'] = "30"                 | Preis in ?
 * ['price_style'] = "fixed"        | muss fixed sein
 *
 * oder:
 * ['price']['11'] = 15             | 12 Eintragungen, fr Staffelpreise je nach Monat! Preis in ?
 * ['price_style'] = "per_month"    | muss per_month sein
 *
 * ArrayEbene 2:
 * ['visible'] = true               | Ist die eintragung momentan aktiv / sichtbar zum auswhlen? true oder false
 * ['include'][0] = "Kaffeflat";    | Gibts Features kostenfrei dazu? / die Option MUSS auch als Option angelegt sein!
 * ['event_status'] = 7;            | Sitzplatzstatus! Kann in der Datenbank unter event_status abgelesen werden!
 *
 */
$seats['VIP']['price'] = "30";
$seats['VIP']['price_style'] = "fixed";
$seats['VIP']['visible'] = true;
$seats['VIP']['include'][0] = "Kaffeflat";
$seats['VIP']['event_status'] = 7;

$seats['Parkett']['price']['01'] = 1;
$seats['Parkett']['price']['02'] = 2;
$seats['Parkett']['price']['03'] = 3;
$seats['Parkett']['price']['04'] = 4;
$seats['Parkett']['price']['05'] = 5;
$seats['Parkett']['price']['06'] = 6;
$seats['Parkett']['price']['07'] = 7;
$seats['Parkett']['price']['08'] = 8;
$seats['Parkett']['price']['09'] = 9;
$seats['Parkett']['price']['10'] = 10;
$seats['Parkett']['price']['11'] = 11;
$seats['Parkett']['price']['12'] = 12;
$seats['Parkett']['price_style'] = "per_month";
$seats['Parkett']['visible'] = true;
$seats['Parkett']['include'][0] = "Kaffeflat";
$seats['Parkett']['default'] = true;
$seats['Parkett']['event_status'] = 11;


/**
 * Definition der Optionen!
 * ArrayEbene 1 = Name der Option (z.B. Kaffeeflat)
 * ArrayEbene 2 = Optionen
 *
 * ['price'] = "5";                     | Kosten
 * ['price_style'] = "additional";      | additional = wird einfach dazugezhlt, percent = wird in % zum Betrag addiert, MUSS dann am Ende stehen
 * ['visible'] = true;                  | ist die Option derzeit sichtbar?
 * ['required'] = true;                 | ist die Option verpflichtent? -> ist sichtbar, aber kann nicht abgewhlt werden
 * ['add_to_user_comment'] = true;      | soll beim Buchen ein Eintrag im User-Kommentarfeld hinterlegt werden?
 */

$options['Kaffeflat']['price'] = "5";
$options['Kaffeflat']['price_style'] = "additional";
$options['Kaffeflat']['visible'] = true;
$options['Kaffeflat']['add_to_user_comment'] = true;


$options['Platzpfand']['price'] = "5";
$options['Platzpfand']['price_style'] = "additional";
$options['Platzpfand']['visible'] = true;
$options['Platzpfand']['required'] = true;
$options['Platzpfand']['add_to_user_comment'] = true;

$options['GratisFick']['price'] = "0";
$options['GratisFick']['price_style'] = "additional";
$options['GratisFick']['visible'] = true;
$options['GratisFick']['add_to_user_comment'] = true;

$options['10Euro aufs Cateringkonto']['price'] = "10";
$options['10Euro aufs Cateringkonto']['price_style'] = "additional";
$options['10Euro aufs Cateringkonto']['visible'] = true;
$options['10Euro aufs Cateringkonto']['add_to_user_comment'] = true;

$options['20Euro aufs Cateringkonto']['price'] = "20";
$options['20Euro aufs Cateringkonto']['price_style'] = "additional";
$options['20Euro aufs Cateringkonto']['visible'] = true;
$options['20Euro aufs Cateringkonto']['add_to_user_comment'] = true;


// WICHTIG: Muss ganz am Ende stehen!!!!
//$options['Paypal Gebühren']['price'] = "0.06";
//$options['Paypal Gebühren']['price_style'] = "percent";
//$options['Paypal Gebühren']['visible'] = true;
//$options['Paypal Gebühren']['required'] = true;
//$options['Paypal Gebühren']['add_to_user_comment'] = false;
?>
