<?php

/**
 * @author Florian Hochriegl, Florian@Hochriegl.de
 * @website www.gamers-congress.de
 * @version 2011033001
 * Dieses Script erstellt einen berweisungsvordruck und
 * - zeigt dem User diesen an
 * - schickt eine Mail an den User mit allen notwendigen Daten
 */
require_once('./fpdf.php');
include_once("../global.php");
include_once("paymentConstants.php");

class PDF extends FPDF {

}

$pdf = new PDF();
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->Image('../images/gc_payment/bg.png', 20, 0, 170);
$pdf->SetFont('Courier', '', 26.5);
$pdf->SetXY(25, 5);
$pdf->Cell(60, 10, '');
$pdf->SetY(10);
$pdf->ln(11);
$pdf->Cell(18);
$pdf->Cell(60, 10, $bankverbindung['empfaenger_name']);
$pdf->ln(9.5);
$pdf->Cell(18);
$pdf->Cell(60, 10, $bankverbindung['empfaenger_kontonr']);
$pdf->Cell(47);
$pdf->Cell(60, 10, $bankverbindung['empfaenger_blz']);
$pdf->ln(9.5);
$pdf->Cell(18);
$pdf->Cell(60, 10, $bankverbindung['empfaenger_bankname']);
$pdf->ln(9.5);
$pdf->Cell(102.5);
$pdf->Cell(60, 10, $amount);
$pdf->ln(9.5);
$pdf->Cell(18);
$kundenreferenznummer = substr($GCName, 0, 27 + 1);
$pdf->Cell(60, 10, $kundenreferenznummer);
$pdf->ln(9.5);
$pdf->Cell(18);
$verwendungszweck = "Rechnungsnummer: " . $transactionid;
$pdf->Cell(60, 10, $verwendungszweck);
$pdf->ln(10);
$pdf->Cell(18);
$pdf->Cell(60, 10, $kontoinhaber);
$pdf->ln(10);
$pdf->Cell(18);
$pdf->Cell(60, 10, $kontonummer);

// Save to File
$pdf->Output("./rechnungen/Vordruck_" . $transactionid . ".pdf", "F");



// Send via Email
$user = $DB->query_all("SELECT id, nick, email, vorname, nachname FROM user WHERE id=" . $CURRENT_USER->id);
$user = $user[0];
$subject = "Gamers' Congress - Kontodaten";
$body = "Hallo " . $user['vorname'] . ",\r\n";
$body .= "Anbei ist ein PDF mit dem berweisungsvordruck\r\n";
$body .= "\r\n";
$body .= "Solltest du es vorziehen per OnlineBanking zu berweisen, sind hier nochmals die Daten: \r\n";
$body .= "\r\n";
$body .= "Kontoinhaber: LAN Foundation e.V.\r\n";
$body .= "Kontonummer: 100267856\r\n";
$body .= "Bankleitzahl: 74392300\r\n";
$body .= "Bank: VR-Bank Vilsbiburg eG\r\n";
$body .= "BIC: GENODEF1VBV\r\n";
$body .= "IBAN: DE43743923000100267856\r\n";
$body .= "Verwendungszweck: Rechnung " . $transactionid . "\r\n";
$body .= "\r\n";
$body .= "\r\n";
$body .= "\n\nDein Gamers' Congress Team\n";
$body .= "http://www.gamers-congress.de";

if (!class_exists("PHPMailer"))
    include_once($global['include_path'] . "class.phpmailer.php");

$MAIL = new PHPMailer();
$MAIL->From = $global['email'];
$MAIL->FromName = $global['emailuser'];
$MAIL->Subject = $subject;
if (class_exists('htmlout'))
    $MAIL->Subject = htmlout::unxmlentities($MAIL->Subject);
$MAIL->Body = $body;
$MAIL->addAddress($user['email'], $user['vorname'] . " " . $user['nachname']);
$MAIL->AddAttachment("./rechnungen/Vordruck_" . $transactionid . ".pdf", "Vordruck.pdf");
$MAIL->Send();


// Send to Browser
$pdf->Output("./rechnungen/Vordruck_" . $transactionid . ".pdf", "I");
?>