<?php

/**
 * @author Florian Hochriegl, Florian@Hochriegl.de
 * @website www.gamers-congress.de
 * @version 2011040401
 * Dieses Script erlaubt das bezahlen des Unkostenbeitrages fr einen oder mehrere Personen
 * Es knnen diverse Optionen ausgewhlt werden
 * und per PayPal oder per berweisungsformular bezahlt werden
 */
// Notwendige Inputs
include("../global.php");
include("paymentConstants.php");

// Page-Title
$PAGE->htmltitle = $PAGE->sitetitle = "Gruppenzahlung :)";

// $Step Beinhaltet den aktuellen Zustand innerhalb des Bezahlmodelles
$step = $_REQUEST['step'];

// $paypal_users beinhaltet als Array alle User-IDs fr die eine berweisung vorgenommen werden soll
$paypal_users = $_REQUEST['paypal_users'];

// Wenn im vorherigen Step eine UID bergeben wurde, fge diese zu $paypal_users hinzu
if ($_REQUEST['uid'] != "" && $_REQUEST['uid'] > 0) {

    // Falls bereits UIDs innerhalb des $paypal_users Arrays bestehen, prfe ob die UID schon drinnen ist oder nicht und fge sie ggfls. hinzu
    if (is_array($paypal_users)) {
        if (!in_array($_REQUEST['uid'], $paypal_users)) {
            $paypal_users[] += $_REQUEST['uid'];
        }
    } else {
        $paypal_users[] += $_REQUEST['uid'];
        //echo "array gibts no ned";
    }
}

// Notwendig um sptere Fehler beim Iterieren zu unterbinden
if (!is_array($paypal_users))
    $paypal_users = array();

// Falls kein oder ein ungltiger Step bergeben wurde -> fange von vorne an
if (!($step >= 0))
    $step = 0;

// Wenn der Button "Optionen auswhlen" gedrckt wurde, setze Step auf 1, falls aber noch gar keine User ausgewhlt wurden, springe wieder auf Step0
if (isset($_REQUEST['step1_no_more_users'])) {
    $step = 1;

    if (sizeof($paypal_users) == 0)
        $step = 0;
}

// Wenn der Button "weiteren User hinzufgen" gedrckt wurde, verbleibe im Step 0
if (isset($_REQUEST['step0_next_user'])) {
    $step = 0;

    // Fge alle $paypal_users als verstecktes Formularfeld zur Webseite hinzu
    foreach ($paypal_users as $id => $key)
        $paypal_users_hiddenhtml .= " <input type=\"hidden\" name=\"paypal_users[$id]\" value=\"$key\">   ";
}

// Wenn der Button "mich hinzufgen" gedrckt wurde, verbleibe im Step 0, und frge den aktuell eingeloggten User zur Liste hinzu, auhc wieder nur einmal!
if (isset($_REQUEST['step0_add_currentuser'])) {
    $step = 0;

    // Falls bereits UIDs innerhalb des $paypal_users Arrays bestehen, prfe ob die UID schon drinnen ist oder nicht und fge sie ggfls. hinzu
    if (is_array($paypal_users)) {
        if (!in_array($CURRENT_USER->id, $paypal_users))
            $paypal_users[] = $CURRENT_USER->id;
    }
    else {
        $paypal_users[] = $CURRENT_USER->id;
    }

    // Fge alle $paypal_users als verstecktes Formularfeld zur Webseite hinzu
    foreach ($paypal_users as $id => $key)
        $paypal_users_hiddenhtml .= " <input type=\"hidden\" name=\"paypal_users[$id]\" value=\"$key\">   ";
}

// Wenn der Button zur Kasse gehen gedrckt wurde, springe auf Step 2
if (isset($_REQUEST['step2'])) {
    $step = 2;
}

// Wenn der Button per berweisung zahlen gedrckt wurde, springe zu Step 3
if (isset($_REQUEST['step3_ueberweisung']) || isset($_REQUEST['step3_ueberweisung_x']) || isset($_REQUEST['step3_ueberweisung_y'])) {
    $step = 3;
}

if ($CURRENT_USER->id == "")
    $step = "notloggedin";

// Zur Identifikation der User: Rufe vorname, nick, nachname zu den UIDs in $paypal users ab.
if ($step == 0 || $step == 1 || $step == 2) {
    // Nur wenn Bereits user existieren -> DB Abfrage
    if (is_array($paypal_users)) {
        $query = "SELECT id, nick, vorname, nachname from user
                    WHERE ";
        foreach ($paypal_users as $id => $key)
            $query .= "id = " . $key . " OR ";

        $query .= "id = 'gibtsniemals'";

        $result = mysql_query($query) OR die(mysql_error() . "<br>" . $query);

        // Speichere die Daten im Array $paypal_users_data
        while ($row = mysql_fetch_object($result)) {
            $paypal_users_data[$row->id]['vorname'] = $row->vorname;
            $paypal_users_data[$row->id]['nachname'] = $row->nachname;
            $paypal_users_data[$row->id]['nick'] = $row->nick;
        }
    }
}

function show_kontodaten($rechnungsnummer) {

    global $bankverbindung;
    global $GCName;

    return '<table border="0" width="100%">
          <tr>
          <td colspan = "2">Oder zum hndisch berweisen: <br><br></td>
          </tr>
          <tr><td align="right">Empfnger : </td><td align="left"> ' . $bankverbindung['empfaenger_name'] . ' <br></td></tr>
          <tr><td align="right">KontoNummer : </td><td align="left">  ' . $bankverbindung['empfaenger_kontonr'] . ' <br></td></tr>
          <tr><td align="right">Bankleitzahl : </td><td align="left">  ' . $bankverbindung['empfaenger_blz'] . ' <br></td></tr>
          <tr><td align="right">Bankname : </td><td align="left">  ' . $bankverbindung['empfaenger_bankname'] . ' <br></td></tr>

           <tr><td align="right">Verwendungszweck 1 : </td><td align="left"> ' . $GCName . '<br></td></tr>
           <tr><td align="right">Verwendungszweck 2 : </td><td align="left"> Rechnungsnummer: ' . $rechnungsnummer . '<br></td></tr>

</table>';
}

function show_rechnung_details($id) {

    global $options;
    global $seats;

    $query = "SELECT * from gc_payment_details where id = $id;";
    $result = mysql_query($query) OR die(mysql_error() . "<br>" . $query);

    while ($row = mysql_fetch_object($result)) {
        $paymentDetail[$row->userid][$row->option] = $row->value;
        $paymentUsers[$row->userid] = 1;
    }

    $query = "SELECT id, nick, vorname, nachname from user
                    WHERE ";
    foreach ($paymentUsers as $userid => $key)
        $query .= "id = " . $userid . " OR ";

    $query .= "id = 'gibtsniemals'";


    $result = mysql_query($query) OR die(mysql_error() . "<br>" . $query);

    while ($row = mysql_fetch_object($result)) {
        $paypal_users_data[$row->id]['vorname'] = $row->vorname;
        $paypal_users_data[$row->id]['nachname'] = $row->nachname;
        $paypal_users_data[$row->id]['nick'] = $row->nick;
    }



    $money_for_all = 0;

    $myOutput .= '
        <table border="0" width="100%">';


    foreach ($paymentUsers as $userid => $nothing) {
        $money_for_user = 0;

        $myOutput .= "	<tr>
		<td>" . $paypal_users_data[$userid]['vorname'] . " " . $paypal_users_data[$userid]['nachname'] . " <br>
                    " . $paypal_users_data[$userid]['nick'] . "</td>
		<td>";


        // Sitzplatzkosten
        if ($seats[$paymentDetail[$userid][seat]]['price_style'] == "fixed")
            $price = $seats[$paymentDetail[$userid][seat]]['price'];
        else if ($seats[$paymentDetail[$userid][seat]]['price_style'] == "per_month")
            $price = $seats[$paymentDetail[$userid][seat]]['price'][date("m")];

        $myOutput .= $paymentDetail[$userid]['seat'] . " " . $price . " &euro; <br>";


        $money_for_user += $price;


        // Optionskosten
        foreach ($options as $optionname => $option) {
            if (isset($paymentDetail[$userid][$optionname]) || $option['required'] == true) {

                if ($option['price_style'] == "additional")
                    $price = $option['price'];
                else if ($option['price_style'] == "percent")
                    $price = $money_for_user * $option['price'];
                else
                    $price = 666;

                $myOutput .= $optionname . " " . $price . " &euro;<br>";
                $money_for_user += $price;
            }
        }

        $myOutput .= "<br>Kosten fr User: " . $money_for_user . "<br>";
        $money_for_all += $money_for_user;
        $myOutput .= "</td>
	</tr>

        <tr><td colspan=2>--------------------------------------------------------------------------------------------------</td></tr>
";
    }



    $myOutput .= '
            </table>';

    $myOutput .= "Gesamtkosten: " . number_format($money_for_all, 2) . " &euro; <br>";

    $HTML = new htmlout;

    $myOutput = $HTML->message("Rechnungsnummer: " . $id, $myOutput);

    return $myOutput;
}

function step0_checkExisting() {

    global $DB;
    global $CURRENT_USER;

    $query = "SELECT ID from gc_payment WHERE userid = " . $CURRENT_USER->id . " AND paid = 0";

    $offeneRechnungen = $DB->query_all($query);

    if (!is_array($offeneRechnungen))
        return null;

    foreach ($offeneRechnungen AS $ofid) {

        $myOutput .= show_rechnung_details($ofid['ID']);
        $myOutput .= "<br>";
    }
    $myOutput .= show_kontodaten("XY (siehe oben)");
    $myOutput .= "<br>";
    $myOutput .= "<br>";

    return $myOutput;
}

/**
 * **********************************************************************************
 * Datenvorberarbeitung abgeschlossen                                               *
 * beginne mit Ausgabe                                                              *
 * **********************************************************************************
 */
// Schritt 0
if ($step == 0) {




    // Erstelle Ausgabe fr die bereits hinzugefgten User
    // und zeige ein Suchfeld zum Suchen neuer Benutzer an

    $myOutput .= '
<form name="paypal" method="post" action="" onSubmit="return checkSubmit()">
' . $paypal_users_hiddenhtml . '

<table cellpadding="6" cellspacing="1" border="0" width="100%" class="msg"> ';

    if (is_array($paypal_users))
        foreach ($paypal_users as $id => $key) {

            $myOutput .= '<tr>
    <td class="msgrow1" nowrap>' . $key . '</td>
    <td class="msgrow2" style="padding:0 6px;" width="100%"> ' . $paypal_users_data[$key]['vorname'] . ' - ' . $paypal_users_data[$key]['nick'] . ' - ' . $paypal_users_data[$key]['nachname'] . ' </td>
  </tr>';
        }

    $myOutput .= '
 </table>

<br><br>
<table cellpadding="6" cellspacing="1" border="0" width="100%" class="msg">
  <tr>
    <td class="msgrow1" nowrap><b>Benutzer</b></td>
    <td class="msgrow2" style="padding:0 6px;" width="100%">
          <div id="divsearch" style="width:100%; display:none;">
            <table cellspacing="0" cellpadding="0" width="100%" border="0">
              <tr>
                <td width="100%"><input type="text" id="insearch" name="search" size="15" style="width:100%;" /></td><td>&nbsp;</td>
                <td><input type="button" value="Suchen" onClick="javascript:searchUser();" /></td>
              </tr>
            </table>
          </div>
          <div id="divselect" style="width:100%; display:none;">
            <table cellspacing="0" cellpadding="0" width="100%" border="0">
              <tr>
                <td width="100%"><select id="inselect" name="uid" style="width:100%"></select></td><td>&nbsp;</td>
                <td><input type="button" value="X" onClick="javascript:clearSearch();" /></td>
             </tr>
           </table>
          </div>
          <noscript>
            <b>Javascript is needed for UserSearch</b>
          </noscript>
    </td>
  </tr>
    <tr>
    <td class="msgrow2" colspan="2" align="right">
        Achtung: Es knnen nur User ausgewhlt werden, die bereits fr das Event angemeldet sind!
    </td>
  </tr>

  <tr>
    <td class="msgrow2" colspan="2" align="right">
        <input type="submit" name="step0_next_user" value="weiteren User hinzufgen" />
        <input type="submit" name="step0_add_currentuser" value="Mich hinzufgen" />
        <input type="submit" name="step1_no_more_users" value="Optionen auswhlen" /></td>
  </tr>
</table>
</form>

<iframe frameborder="0" style="width:0px; height:0px;" src="about:blank" id="operasucks"></iframe>
<script type="text/javascript" src="/user/xmlusersearch.js"></script>
<script type="text/javascript">
<!--

// define variables needed by xmlusersearch.js
var inselect	= document.getElementById(\'inselect\');
var divselect	= document.getElementById(\'divselect\');
var insearch	= document.getElementById(\'insearch\');
var divsearch	= document.getElementById(\'divsearch\');
var event_id	= ' . $GCeventID . ';

var xml_link	= \'/user/?do=xmlsearch\';
var xmllink	= \'/gc_payment/eventUserSearch.php?do=bla\';


function checkSubmit()
{
    if(insearch.value != \'\') {
    	searchUser();
    	return false;
    }
}

initUserSearch(\'\');

//-->
</script>
';

    $HTML = new htmlout;

    $myOutput1 = step0_checkExisting();
    if ($myOutput1 != "" && $paypal_users[0] == "" ) {
        $myFinalOutput = $HTML->message("Achtung - offene Eintrge vorhanden!", $myOutput1);
        $myFinalOutput .= "<br>";
    }

    $myFinalOutput .= $HTML->message("Benutzer zum zahlen auswhlen", $myOutput);

    $myOutput = $myFinalOutput;
}

// Schritt 2
// Zeige eine Sitzplatzauswahl, sowie die Optionenauswahl pro User an
if ($step == 1) {

    $myOutput .= '
        <form name="paypal" method="post" action="./">
        <table border="0" width="100%">';

    if (is_array($paypal_users))
        foreach ($paypal_users as $id => $userid) {

            $myOutput .= "<input type=\"hidden\" name=\"paypal_users[$id]\" value=\"$userid\">   ";



            $myOutput .= "	<tr>
		<td>" . $paypal_users_data[$userid]['vorname'] . " " . $paypal_users_data[$userid]['nachname'] . " <br>
                    " . $paypal_users_data[$userid]['nick'] . "</td>
		<td>";

            // Sitzplatzauswahl
            $myOutput .= '<select name="data[' . $userid . '][seat]" size="1">';

            foreach ($seats as $seatname => $seat) {
                if ($seat['default'] == true)
                    $selected = " selected ";

                $myOutput .= '<option ' . $selected . ' >' . $seatname . '</option>';
            }
            $myOutput .= '</select> <br>';


            // Optionenauswahl
            foreach ($options as $optionname => $option) {
                if ($option['required'] == true)
                    $checked = "checked disabled";
                else
                    $checked = "";

                if ($option['visible'] != false)
                    $myOutput .= '<input type="checkbox" name="data[' . $userid . '][option][' . $optionname . ']" value="' . $optionname . '" ' . $checked . '>  ' . $optionname . ' <br>';
            }


            $myOutput .= "</td>
	</tr>

        <tr><td colspan=2>--------------------------------------------------------------------------------------------------</td></tr>
";
        }

    $myOutput .= '
            </table>
             <input type="submit" name="step2" value="zur Kasse gehen" />
            </form>';


    $HTML = new htmlout;
    $myOutput = $HTML->message("Optionen auswählen", $myOutput);
}

// Schritt 2
// Zeige nochmals eine bersicht an und eine Auswahl zur PayPal oder berweisungszahlung
if ($step == 2) {

    $data = $_REQUEST['data'];
    $money_for_all = 0;

    $myOutput .= "Folgende Gebhren wurden ermittelt: <br>";

    $myOutput .= '
        <form name="paypal" method="post" action="./">
        <table border="0" width="100%">';


    foreach ($paypal_users as $id => $userid) {
        $money_for_user = 0;

        $myOutput .= "	<tr>
		<td>" . $paypal_users_data[$userid]['vorname'] . " " . $paypal_users_data[$userid]['nachname'] . " <br>
                    " . $paypal_users_data[$userid]['nick'] . "</td>
		<td>";


        // Sitzplatzkosten
        if ($seats[$data[$userid][seat]]['price_style'] == "fixed")
            $price = $seats[$data[$userid][seat]]['price'];
        else if ($seats[$data[$userid][seat]]['price_style'] == "per_month")
            $price = $seats[$data[$userid][seat]]['price'][date("m")];

        $myOutput .= $data[$userid][seat] . " " . $price . " &euro; <br>";
        $money_for_user += $price;


        // Optionskosten
        foreach ($options as $optionname => $option) {
            if (isset($data[$userid][option][$optionname]) || $option['required'] == true) {

                if ($option['price_style'] == "additional")
                    $price = $option['price'];
                else if ($option['price_style'] == "percent")
                    $price = $money_for_user * $option['price'];
                else
                    $price = 666;



                $myOutput .= $optionname . " " . $price . " &euro;<br>";
                $money_for_user += $price;
            }
        }

        $myOutput .= "<br>Kosten fr User: " . $money_for_user . " &euro;<br>";
        $money_for_all += $money_for_user;


        $myOutput .= "</td>
	</tr>

        <tr><td colspan=2>--------------------------------------------------------------------------------------------------</td></tr>
";
    }


    $myOutput .= '
            </table>';


    $myOutput .= "Gesamtkosten: " . number_format($money_for_all, 2) . " &euro; <br>";

    $myOutput .= '<input type="button" name="back" value="Zurck" onclick="javascript:history.back();" />';
    $myOutput .= '</form>';



    // Rechnungsdaten in die Datenbank schreiben
    $query = "INSERT INTO `gc_payment` ( `amount` , `userid`  ) VALUES ('" . $money_for_all . "' , $CURRENT_USER->id);";
    $result = mysql_query($query) OR die(mysql_error());

    // $transactionid = RechnungsID
    $transactionid = mysql_insert_id();

    // REchnungsdetails in die Datenbank schreiben
    foreach ($paypal_users as $id => $userid) {
        // Sitz Eintragen
        $query = "INSERT INTO `gc_payment_details` ( `id` ,`userid` ,`option` ,`value` )
            VALUES (    '" . $transactionid . "' ,
                        '" . $userid . "' ,
                        'seat' ,
                        '" . $data[$userid][seat] . "' );";
        $result = mysql_query($query) OR die(mysql_error());


        foreach ($options as $optionname => $option) {
            if (isset($data[$userid][option][$optionname]) || $option['required'] == true) {

                // Optionen Eintragen
                $query = "INSERT INTO `gc_payment_details` ( `id` ,`userid` ,`option` ,`value` )
            VALUES (    '" . $transactionid . "' ,
                        '" . $userid . "' ,
                        '" . $optionname . "' ,
                        '1' );";

                $result = mysql_query($query) OR die(mysql_error());
            }
        }
    }
    // Bezahloptionen einblenden

    $myOutput .= '
<div align="center">
<table border="0" width="100%">
        <tr>
            <td width="50%">';

    $PayPalGebuehren = number_format($money_for_all * 0.019 + 0.35, 2);
    $myOutput .= '

    <form action="https://www.paypal.com/cgi-bin/webscr" method="post">
<input type="hidden" name="cmd" value="_cart">
<input type="hidden" name="business" value="' . $paypalConfig['emailadress'] . '">

<input type="hidden" name="currency_code" value="EUR">
<input type="hidden" name="no_shipping" value="1">
<input type="hidden" name="no_note" value="1">
<input type="hidden" name="upload" value="1">

<input type="hidden" name="custom" value="' . $transactionid . '">



<input type="hidden" name="cancel_return" value="' . $paypalConfig['cancel_return'] . '">
<input type="hidden" name="notify_url" value="' . $paypalConfig['notify_url'] . '">
<input type="hidden" name="return" value="' . $paypalConfig['return'] . '">

<input type="hidden" name="item_name_1" value="Sitzplatzkosten ' . $GCName . '">
<input type="hidden" name="amount_1" value="' . number_format($money_for_all, 2) . '">

<input type="hidden" name="item_name_2" value="PayPal Gebühren">
<input type="hidden" name="amount_2" value="' . $PayPalGebuehren . '">

<input type="image" src="https://www.paypalobjects.com/de_DE/DE/i/btn/x-click-but6.gif" name="submit" alt="Make payments with PayPal - it\'s fast, free and secure!">
</form> 
<p><font size="1">zzgl. PayPal Gebühren</font></p>';
    $myOutput .= '</td>
            <td width="50%">
                    <form action="./" method="post">
                        <input type="hidden" name="transactionid" value="' . $transactionid . '">
                        <input type="hidden" name="amount" value="' . number_format($money_for_all, 2) . '">

                        <input type="image" src="/images/gc_payment/ueberweisung.jpg" name="step3_ueberweisung" >
                    </form>
<p><font size="1">zum Ausdrucken</font></p>
</td>
          </tr>
          </table>';


    $myOutput .= show_kontodaten($transactionid);


    $myOutput .= '</div>';



    $HTML = new htmlout;
    $myOutput = $HTML->message("bersicht", $myOutput);
}


// Step 3
// Zeige ein Eingabefeld fr die Kontodaten des Users um ein Formular zu erzeugen
if ($step == 3) {

    $myOutput .= '
        <form action="vordruck.php" method="POST">
        <table border="0" width="100%">
        <tr>
            <td>Kontonummer:</td>
            <td><input type="text" name="kontonummer" /></td>
        </tr>
        <tr>
            <td>Kontoinhaber:</td>
            <td><input type="text" name="kontoinhaber" value="' . $CURRENT_USER->nachname . ' ' . $CURRENT_USER->vorname . '" /></td>
        </tr>
        </table>
		<input type="hidden" name="transactionid" value="' . $transactionid . '" />
		<input type="hidden" name="amount" value="' . $amount . '" />
		<input type="hidden" name="sent" value="1" />
                <br>
		<div align="center"><input type="submit" value="berweisungsvordruck generieren" /></div>
		</form>
                <br>
		Deine Kontodaten werden <b>nicht</b> gespeichert! <br/>
		Es wird lediglich der berweisungsvordruck fr dich erstellt. <br>
                Du bekommst die Daten zusätzlich noch per EMail bermittelt! <br><br>
                Natrlich kannst du auch einfach auf weiter klicken ohne was einzutragen :)';

    $HTML = new htmlout;
    $myOutput = $HTML->message("Zahlen per berweisung", $myOutput);
}


if ($CURRENT_USER->id == "") {
    $HTML = new htmlout;
    $myOutput = $HTML->message("Nicht eingeloggter Benutzer", "Hallo User, bitte logge dich zuerst ein um dieses Script zu benutzen!");
}


$output = $myOutput;

$PAGE->render($output);
?>