<?php

/**
 * @author Florian Hochriegl, Florian@Hochriegl.de
 * @website www.gamers-congress.de
 * @version 2011040901
 * Admin-Interface fr das Rechnungsmodul
 * erlaubt offene Zahlungen anzuzeigen
 * zeigt Details zu einer offenen Zahlung an
 * kann eine Zahlung freigeben oder verstecken (ist dann nur noch ber die Datenbank einzusehen)
 */
include_once("../../global.php");
include_once($global['script_root'] . "/gc_payment/paymentConstants.php");
include_once($global['script_root'] . "/gc_payment/paymentFunctions.php");


$PAGE->htmltitle = $PAGE->sitetitle = "GC Payment Admininterface";

function menu() {

    global $GCeventID;
    global $global;

    $myOutput .= '<table border="0" width="100%">
                <tr>
                    <td><a href="?do=show_rechnungen">Zeige offene Rechnungen</a></td>
                    <td><a href="?do=show_konto">Zeige unbearbeitete Kontoeingnge</a></td>
                </tr>
                <tr>
                    <td><a href="?do=show_activated">Zeige freigegebene Rechnungen</a></td>
                    <td></td>
                </tr>
                <tr>
                    <td><a href="/gc_payment/checkBankkonto.php">Kontoeintrge neu verarbeiten</a></td>
                    <td><a href="../?do=event_guests&id=' . $GCeventID . '">Teilnehmer verwalten</a></td>
	</tr>
</table>';


    $HTML = new htmlout;
    return $HTML->message("GC Payment Admin Menu", $myOutput);
}

function explaination_rechnungen() {

    $myOutput .= '<table border="0" width="100%">
	<tr>
            <td><img heigth=32 width=32 src="/images/gc_payment/details.png"></td>
            <td>Zeige Details zu der "Rechnung" an</td>
        </tr>
        <tr>
            <td><img heigth=32 width=32 src="/images/gc_payment/ok.png"></td>
            <td>Gebe die Rechnung frei, d.h. der User wird mit all seinen Optionen auf bezahlt gesetzt! Eine berprfung durch das System wird nicht durchgefhrt!</td>
	</tr>
                <tr>
            <td><img heigth=32 width=32 src="/images/gc_payment/hide.png"></td>
            <td>Der Eintrag wird in der Datenbank versteckt (z.B. falls eine doppelte / ungltige Rechnung hier steht)</td>
	</tr>
                <tr>
            <td><img heigth=32 width=32 src="/images/gc_payment/nichtbezahlt.png"></td>
            <td>Der User hat lt. Datenbank fr das Event noch nicht bezahlt</td>
	</tr>
        <tr>
            <td><img heigth=32 width=32 src="/images/gc_payment/bezahlt.png"></td>
            <td>Der User hat lt. Datenbank fr das Eventbereits bezahlt</td>
	</tr>
         <tr>
            <td><img heigth=32 width=32 src="/images/gc_payment/bezahltunklar.png"></td>
            <td>Der User ist scheinbar nicht fr das Event angemeldet oder ist ein ORGA </td>
	</tr>


</table>';


    $HTML = new htmlout;

    return $HTML->message("GC Payment Admin Menu", $myOutput);
}

function explaination_konto() {

    $myOutput .= '<table border="0" width="100%">
        <tr>
            <td><img heigth=32 width=32 src="/images/gc_payment/ok.png"></td>
            <td>Setze den Kontoeintrag auf besttigt (eine weitere Verarbeitung findet nicht statt! Den User oder die zugehrige Rechnung bitte selbst auf bezahlt setzen!)</td>
	</tr>
                <tr>
            <td><img heigth=32 width=32 src="/images/gc_payment/hide.png"></td>
            <td>Setze den Kontoeintrag auf versteckt (falls der Zahlungseingang z.B. nichts mit einem User zu tun hat)</td>
	</tr>
</table>';


    $HTML = new htmlout;

    return $HTML->message("GC Payment Admin Menu", $myOutput);
}

function explaination_rechnung_details() {

    $myOutput .= '<table border="0" width="100%">
	<tr>
            <td><img heigth=32 width=32 src="/images/gc_payment/back.png"></td>
            <td>Gehe zurck zur bersicht</td>
        </tr>
        <tr>
            <td><img heigth=32 width=32 src="/images/gc_payment/ok.png"></td>
            <td>Gebe die Rechnung frei, d.h. der User wird mit all seinen Optionen auf bezahlt gesetzt! Eine berprfung durch das System wird nicht durchgefhrt!</td>
	</tr>
                <tr>
            <td><img heigth=32 width=32 src="/images/gc_payment/hide.png"></td>
            <td>Der Eintrag wird in der Datenbank versteckt (z.B. falls eine doppelte / ungltige Rechnung hier steht)</td>
	</tr>
</table>';


    $HTML = new htmlout;

    return $HTML->message("GC Payment Admin Menu", $myOutput);
}

function show_rechnungen() {

    global $GCeventID;
    global $DB;

    $myOutput .= "<script type=\"text/javascript\">
      								//<![CDATA[
        							function link(ziel) {
        		  				if(confirm('Bezahlung wirklich freigeben?'))
     			       			top.location.href = ziel;
    			    				}
   		  							//]]>
  				</script>";

    $query = "SELECT DISTINCT
        gc_payment.ID ,
        amount,
        gc_payment.userid AS einreicher_user_id,
        gc_payment_details.userid AS detail_user_id,
        user.nick AS einreicher_user_nick,
        user.vorname AS einreicher_user_vorname,
        user.nachname AS einreicher_user_nachname,
        (
                            SELECT nick
                            FROM user
                            WHERE user.id = gc_payment_details.userid
                            ) AS detail_user_name,
        (
                            SELECT bezahlt
                            FROM event_teilnehmer
                            WHERE user_id = gc_payment_details.userid
                            AND event_id = " . $GCeventID . "
                            ) AS detail_user_bezahlt

                FROM gc_payment

        INNER JOIN gc_payment_details ON gc_payment.ID = gc_payment_details.id
        INNER JOIN user ON user.id = gc_payment.userid

                WHERE paid =0;";

    $results = $DB->query_all($query);

    foreach ($results AS $result) {
        $rechnungen[] = $result;
    }

    foreach ($rechnungen AS $rechnung) {

        $rechnungen_ordered[$rechnung['ID']]['ID'] = $rechnung['ID'];
        $rechnungen_ordered[$rechnung['ID']]['amount'] = $rechnung['amount'];
        $rechnungen_ordered[$rechnung['ID']]['einreicher_user_id'] = $rechnung['einreicher_user_id'];
        $rechnungen_ordered[$rechnung['ID']]['einreicher_user_nick'] = $rechnung['einreicher_user_nick'];
        $rechnungen_ordered[$rechnung['ID']]['einreicher_user_vorname'] = $rechnung['einreicher_user_vorname'];
        $rechnungen_ordered[$rechnung['ID']]['einreicher_user_nachname'] = $rechnung['einreicher_user_nachname'];
        $rechnungen_ordered[$rechnung['ID']]['detail_user'][$rechnung['detail_user_id']]['detail_user_id'] = $rechnung['detail_user_id'];
        $rechnungen_ordered[$rechnung['ID']]['detail_user'][$rechnung['detail_user_id']]['detail_user_name'] = $rechnung['detail_user_name'];
        $rechnungen_ordered[$rechnung['ID']]['detail_user'][$rechnung['detail_user_id']]['detail_user_bezahlt'] = $rechnung['detail_user_bezahlt'];
    }
    // echo_r( $rechnungen_ordered);

    $myOutput .= '
        <table border="0" width="100%">
          <tr>
            <td >ID</td>
            <td >Eingericht von</td>
            <td >Betrag</td>
            <td >User in der Rechnung</td>
            <td width=120 >Freigeben</td>
          </tr>';

    foreach ($rechnungen_ordered AS $rechnung) {


        $counter++;
$details = "";

        foreach ($rechnung['detail_user'] AS $detail) {
            if ($detail['detail_user_bezahlt'] == 0)
                $moneyimage = "nichtbezahlt.png";
            else if ($detail['detail_user_bezahlt'] == 1)
                $moneyimage = "bezahlt.png";
            else
                $moneyimage = "bezahltunklar.png";

            $details .= '<img src="/images/gc_payment/' . $moneyimage . '" heigth="24" width="24"> <a href="/user/?id=' . $detail['detail_user_id'] . '">' . $detail['detail_user_name'] . '</a><br>';
        }


        $myOutput .= '<tr valign="top" class="msgrow' . ($counter % 2 ) . '" >
              <td>' . $rechnung['ID'] . '</td>

              <td>' . $rechnung['einreicher_user_vorname'] . ' <a href="/user/?id=' . $rechnung['einreicher_user_id'] . '">' . $rechnung['einreicher_user_nick'] . '</a>  ' . $rechnung['einreicher_user_nachname'] . '</td>
              <td>' . $rechnung['amount'] . ' &euro;</td>

              <td>' . $details . ' </td>

              <td>
                    <a href=./?do=show_rechnung_details&id=' . $rechnung['ID'] . '>     <img heigth=24 width=24 src="/images/gc_payment/details.png"></a>
                    <a href="#" onclick="link(\'./?do=activate&id=' . $rechnung['ID'] . '\');"> <img heigth=24 width=24 src="/images/gc_payment/ok.png"></a>
                    <a href=./?do=hide&id=' . $rechnung['ID'] . '>         <img heigth=24 width=24 src="/images/gc_payment/hide.png"></a>
              </td>

              </tr>
';
    }

    $myOutput .= '</table>';

    $HTML = new htmlout;
    $myOutput = $HTML->message("Offene Zahlungen", $myOutput);

    $myOutput = "Achtung: Eintragungen bitte nur durch Kruzifix vornehmen lassen - oder nach expliziter Rcksprache mitm Flo!!!!<br><br>" . $myOutput;


    return $myOutput;
}

function show_rechnungen_orginal() {

    global $GCeventID;

    $myOutput .= "<script type=\"text/javascript\">
      								//<![CDATA[
        							function link(ziel) {
        		  				if(confirm('Bezahlung wirklich freigeben?'))
     			       			top.location.href = ziel;
    			    				}
   		  							//]]>
  				</script>";

    $query = "SELECT gc_payment.ID , amount, userid, vorname, nick, nachname , (
                            SELECT bezahlt
                            FROM event_teilnehmer
                            WHERE user_id = gc_payment.userid
                            AND event_id = " . $GCeventID . "
                            ) AS bezahlt
                FROM gc_payment
                INNER JOIN user ON user.id = gc_payment.userid
                WHERE paid =0;";
    $result = mysql_query($query) OR die(mysql_error() . "<br>" . $query);

    $myOutput .= '
        <table border="0" width="100%">
          <tr>
            <td >ID</td>
            <td >Eingericht von</td>
            <td >user freigeschalten?</td>
            <td >Flliger Betrag</td>
            <td width=120 >Freigeben</td>
          </tr>';

    while ($row = mysql_fetch_object($result)) {

        if ($row->bezahlt == 0)
            $moneyimage = "nichtbezahlt.png";
        else if ($row->bezahlt == 1)
            $moneyimage = "bezahlt.png";
        else
            $moneyimage = "bezahltunklar.png";

        $myOutput .= '<tr>
              <td>' . $row->ID . '</td>

              <td>' . $row->vorname . ' ' . $row->nick . ' ' . $row->nachname . '</td>

              <td><div align="center"><img src="/images/gc_payment/' . $moneyimage . '" heigth="32" width="32"></div></td>

              <td>' . $row->amount . ' &euro;</td>

              <td>
                    <a href=./?do=show_rechnung_details&id=' . $row->ID . '>     <img heigth=32 width=32 src="/images/gc_payment/details.png"></a>
                    <a href="#" onclick="link(\'./?do=activate&id=' . $row->ID . '\');"> <img heigth=32 width=32 src="/images/gc_payment/ok.png"></a>
                    <a href=./?do=hide&id=' . $row->ID . '>         <img heigth=32 width=32 src="/images/gc_payment/hide.png"></a>
              </td>

              </tr>
';
    }

    $myOutput .= '</table>';

    $HTML = new htmlout;
    $myOutput = $HTML->message("Offene Zahlungen", $myOutput);

    $myOutput = "Achtung: Eintragungen bitte nur durch Kruzifix vornehmen lassen - oder nach expliziter Rcksprache mitm Flo!!!!<br><br>" . $myOutput;


    return $myOutput;
}

function show_activated() {

    global $GCeventID;
    global $DB;

    $gesamt = 0;

    $payments = $DB->query_all("SELECT gc_payment.ID , amount, userid, vorname, nick, nachname ,approved_by, approved_at,
                            (
                            SELECT nick
                            FROM user
                            WHERE id = approved_by
                            ) AS approved_by_nick

                FROM gc_payment
                INNER JOIN user ON user.id = gc_payment.userid
                WHERE paid =1;");


    $myOutput .= '<table border="0" width="100%">
          <tr>
            <td>ID</td>
            <td>&euro;</td>
            <td>Eingericht von</td>
            <td>Freigeschalten von</td>
            <td>Freigeschalten am<td>
          </tr>';

    foreach ($payments AS $payment) {

        $gesamt += $payment['amount'];

        if ($payment['approved_by_nick'] != "")
            $approved_by_nick = $payment['approved_by_nick'];
        else
            $approved_by_nick = $payment['approved_by'];

        $myOutput .= '<tr>
              <td>' . $payment['ID'] . '</td>

             <td>' . $payment['amount'] . ' &euro;</td>


              <td>' . $payment['vorname'] . ' ' . $payment['nick'] . ' ' . $payment['nachname'] . '</td>

              <td>' . $approved_by_nick . '</td>

              <td>' . $payment['approved_at'] . '</td>

             </tr>
';
    }

    $myOutput .= '</table>';

    $myOutput .= "<br><br>Gesamt: $gesamt &euro;";
    $HTML = new htmlout;
    $myOutput = $HTML->message("Freigegebene Zahlungen", $myOutput);

    return $myOutput;
}

function show_konto() {

    global $DB;

    $myOutput .= "<script type=\"text/javascript\">
      								//<![CDATA[
        							function link(ziel) {
        		  				if(confirm('Bezahlung wirklich freigeben?'))
     			       			top.location.href = ziel;
    			    				}
   		  							//]]>
  				</script>";


    $myOutput .= '<table border="0" width="100%">
          <tr>
            <td>Datum</td>
            <td>Name</td>
            <td>Betrag</td>
            <td>Betreff<td>
          </tr>';

    $gc_payment_konto = $DB->query_all("SELECT * FROM gc_payment_konto WHERE processed = 0;");

    if (is_array($gc_payment_konto))
        foreach ($gc_payment_konto as $gcp) {

            $gcp['betreff'] = str_replace('|', '<br>', $gcp['betreff']);

            $myOutput .= '<tr>
              <td>' . $gcp['entrydate'] . '</td>

              <td>' . $gcp['name'] . '</td>

              <td>' . $gcp['value'] . ' &euro;</td>

              <td>' . $gcp['betreff'] . '</td>

              <td>
                    <a href="./?do=process_konto&value=1&uuid=' . $gcp['uuid'] . '"> <img heigth=32 width=32 src="/images/gc_payment/ok.png"></a>
                    <a href="./?do=process_konto&value=2&uuid=' . $gcp['uuid'] . '"> <img heigth=32 width=32 src="/images/gc_payment/hide.png"></a>
              </td>
              </tr>';
        }

    $myOutput .= '</table>';

    $HTML = new htmlout;
    $myOutput = $HTML->message("unbesttigte Kontoeingnge", $myOutput);

    return $myOutput;
}

function process_konto() {

    global $value;
    global $uuid;
    global $DB;

    $query = "UPDATE gc_payment_konto
        SET processed = " . $value . "
            WHERE uuid = '" . $uuid . "';";



    $DB->query($query);

    $HTML = new htmlout;
    $myOutput = $HTML->message("Kontoeingange bearbeitet", "");

    return $myOutput;
}

function hide() {

    global $id;
    global $CURRENT_USER;

    $query = "UPDATE gc_payment
         SET paid = 2,
         hided_at = CURRENT_TIMESTAMP,
         hided_by = '" . $CURRENT_USER->id . "'
         where id = $id;";
    $result = mysql_query($query) OR die(mysql_error() . "<br>" . $query);

    $HTML = new htmlout;
    $myOutput = $HTML->message("o_O", "Zahlung " . $id . " wurde versteckt");

    return $myOutput;
}

function show_rechnung_details() {

    global $id;
    global $options;
    global $seats;

    $query = "SELECT * from gc_payment_details where id = $id;";
    $result = mysql_query($query) OR die(mysql_error() . "<br>" . $query);

    while ($row = mysql_fetch_object($result)) {
        $paymentDetail[$row->userid][$row->option] = $row->value;
        $paymentUsers[$row->userid] = 1;
    }

    $query = "SELECT id, nick, vorname, nachname from user
                    WHERE ";
    foreach ($paymentUsers as $userid => $key)
        $query .= "id = " . $userid . " OR ";

    $query .= "id = 'gibtsniemals'";


    $result = mysql_query($query) OR die(mysql_error() . "<br>" . $query);

    while ($row = mysql_fetch_object($result)) {
        $paypal_users_data[$row->id]['vorname'] = $row->vorname;
        $paypal_users_data[$row->id]['nachname'] = $row->nachname;
        $paypal_users_data[$row->id]['nick'] = $row->nick;
    }



    $money_for_all = 0;

    $myOutput .= "Folgende Gebhren wurden ermittelt: <br>";

    $myOutput .= '
        <table border="0" width="100%">';


    foreach ($paymentUsers as $userid => $nothing) {
        $money_for_user = 0;

        $myOutput .= "	<tr>
		<td>" . $paypal_users_data[$userid]['vorname'] . " " . $paypal_users_data[$userid]['nachname'] . " <br>
                    " . $paypal_users_data[$userid]['nick'] . "</td>
		<td>";


        // Sitzplatzkosten
        if ($seats[$paymentDetail[$userid][seat]]['price_style'] == "fixed")
            $price = $seats[$paymentDetail[$userid][seat]]['price'];
        else if ($seats[$paymentDetail[$userid][seat]]['price_style'] == "per_month")
            $price = $seats[$paymentDetail[$userid][seat]]['price'][date("m")];

        $myOutput .= $paymentDetail[$userid]['seat'] . " " . $price . " &euro; <br>";


        $money_for_user += $price;


        // Optionskosten
        foreach ($options as $optionname => $option) {
            if (isset($paymentDetail[$userid][$optionname]) || $option['required'] == true) {

                if ($option['price_style'] == "additional")
                    $price = $option['price'];
                else if ($option['price_style'] == "percent")
                    $price = $money_for_user * $option['price'];
                else
                    $price = 666;

                $myOutput .= $optionname . " " . $price . " &euro;<br>";
                $money_for_user += $price;
            }
        }

        $myOutput .= "<br>Kosten fr User: " . $money_for_user . "<br>";
        $money_for_all += $money_for_user;
        $myOutput .= "</td>
	</tr>

        <tr><td colspan=2>--------------------------------------------------------------------------------------------------</td></tr>
";
    }



    $myOutput .= '
            </table>';

    $myOutput .= "Gesamtkosten: " . number_format($money_for_all, 2) . " &euro; <br>";


    $myOutput .= "<script type=\"text/javascript\">
      								//<![CDATA[
        							function link(ziel) {
        		  				if(confirm('Bezahlung wirklich freigeben?'))
     			       			top.location.href = ziel;
    			    				}
   		  							//]]>
  				</script>";


    $myOutput .= '<div align="center">
        <a href="#" onClick="history.back()"><img heigth=32 width=32 src="/images/gc_payment/back.png"></a> 
        <a href="#" onclick="link(\'./?do=activate&id=' . $id . '\');"> <img heigth=32 width=32 src="/images/gc_payment/ok.png"></a>
        <a href=./?do=hide&id=' . $id . '><img heigth=32 width=32 src="/images/gc_payment/hide.png"></a>
        

                        </div>';



    $HTML = new htmlout;
    $myOutput = $HTML->message("Details für Rechnung" . $id, $myOutput);

    return $myOutput;
}

function activate() {
    global $id;
    global $CURRENT_USER;
    activateByID($id, $CURRENT_USER->id);

    $HTML = new htmlout;
    $myOutput = $HTML->message("o_O", "Zahlung " . $id . " freigegeben");

    return $myOutput;
}

$do = $_GET['do'];
if (!isset($do))
    $do = "show_rechnungen";

$vorstand = array("205", "2", "793", "149");
if (in_array($CURRENT_USER->id, $vorstand)) {

    if ($do == "show_rechnungen") {
        $myOutput .= menu();
        $myOutput .= "<br>";
        $myOutput .= show_rechnungen();
        $myOutput .= "<br>";
        $myOutput .= explaination_rechnungen();
    } else if ($do == "show_konto") {
        $myOutput .= menu();
        $myOutput .= "<br>";
        $myOutput .= show_konto();
        $myOutput .= "<br>";
        $myOutput .= explaination_konto();
    } else if ($do == "show_activated") {
        $myOutput .= menu();
        $myOutput .= "<br>";
        $myOutput .= show_activated();
    } else if ($do == "process_konto") {
        $myOutput .= menu();
        $myOutput .= "<br>";
        $myOutput .= process_konto();
        $myOutput .= "<br>";
        $myOutput .= show_konto();
        $myOutput .= "<br>";
        $myOutput .= explaination_konto();
    } else if ($do == "show_rechnung_details") {
        $myOutput .= menu();
        $myOutput .= "<br>";
        $myOutput .= show_rechnung_details();
        $myOutput .= "<br>";
        $myOutput .= explaination_rechnung_details();
    } else if ($do == "activate") {
        $myOutput .= menu();
        $myOutput .= "<br>";
        $myOutput .= activate();
        $myOutput .= "<br>";
        $myOutput .= show_rechnungen();
        $myOutput .= "<br>";
        $myOutput .= explaination_rechnungen();
    } else if ($do == "hide") {
        $myOutput .= menu();
        $myOutput .= "<br>";
        $myOutput = hide();
        $myOutput .= "<br>";
        $myOutput .= show_rechnungen();
        $myOutput .= "<br>";
        $myOutput .= explaination_rechnungen();
    } else {
        $myOutput .= menu();
    }
} else {
    $HTML = new htmlout;
    $myOutput = $HTML->message("oO", "Sorry - not for you :(");
}


$output = $myOutput;
$PAGE->render($output);
?>
