// --------------------------------------------------------------------------------------------
//	FinCmdBase.cs
//	Subsembly FinTS API
//	Copyright  2004-2011 Subsembly GmbH
// --------------------------------------------------------------------------------------------

using System;
using System.Collections.Specialized;
using System.Diagnostics;
using System.Text;

using Subsembly.FinTS;
using Subsembly.Swift;

namespace FinCmd
{
	public abstract class FinCmdBase : IFinCmd
	{
		FinOrder m_aOrder;

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sAction"></param>
		/// <param name="vsArgsDict"></param>
		/// <returns></returns>

		public bool Parse(StringDictionary vsArgsDict)
		{
			return this.OnParse(vsArgsDict);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="aService"></param>
		/// <param name="aTanSource"></param>
		/// <returns></returns>

		public virtual int Execute(FinService aService )
		{
			m_aOrder = this.OnCreateOrder(aService);
			if (m_aOrder == null)
			{
				return -1;
			}

			//

			FinServiceResult nRes = aService.SendOrder(m_aOrder);

			// Als Rckgabewert wird der hchste Rckmeldecode aus dem HIRMS genommen.
			// Wurde kein HIRMS bermittelt wird als Rckgabewert 0 eingesetzt.

			int nResult = 0;
			if (m_aOrder.StatusSegment != null)
			{
				int nIndex = m_aOrder.StatusSegment.FindMax();
				nResult = m_aOrder.StatusSegment.GetStatusCode(nIndex);
			}

			return nResult;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="aService"></param>
		/// <returns></returns>

		public virtual string GetResponseData(FinService aService)
		{
			return this.OnGetResponseData(aService, m_aOrder);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sAction"></param>
		/// <param name="vsArgsDict"></param>
		/// <returns></returns>

		protected abstract bool OnParse(StringDictionary vsArgsDict);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="aService"></param>
		/// <returns></returns>

		protected abstract FinOrder OnCreateOrder(FinService aService);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="aOrder"></param>
		/// <returns></returns>

		protected virtual string OnGetResponseData(FinService aService, FinOrder aOrder)
		{
			return null;
		}
	}
}
