<?php
// ############################
// ### PHP Contact Form 2.1 ###
// ############################

/* *** LIZENZVERTRAG ***

Pflichten und Einschrnkungen
-----------------------------

Der Copyright-Vermerk und der Link zu "http://www.gaijin.at/" drfen nicht
entfernt, verndert oder unkenntlicht gemacht werden und mssen gut sichtbar an
unvernderter Position angezeigt werden.

Der Quellcode des Scripts darf nicht verkauft, oder sonst, kostenlos oder gegen
ein Entgelt weitergegeben, oder in irgendeiner Weise verffentlicht werden.
Dies gilt speziell fr die Verffentlichung im Internet, auf sog. Heft-CDs oder
anderen Software-Sammlungen.


Benutzungsrechte
----------------

Das Script darf kostenlos fr private Zwecke genutzt werden. Die Verwendung des
Scripts auf kommerziellen Seiten oder die kommerzielle Verwendung des Scripts
(z.B. durch Webdesigner) ist verboten.

Alle anderen Rechte, einschlielich des Verffentlichungsrechts, bleiben beim
Autor.

Es besteht kein Recht auf Support oder sonstige Hilfestellung durch den Autor.

Das Script kann an die persnlichen Erfordernisse angepasst werden. Der
Copyright-Vermerk und der Link zu "http://www.gaijin.at/" mssen in der unter
"Pflichten und Einschrnkungen" angegebenen Form erhalten bleiben.

Zuwiderhandlungen gegen Bestimmungen dieses Lizenzvertrages knnen
strafrechtlich und zivilrechtlich verfolgt werden.


Haftungsausschluss
------------------

Die Verwendung des Scripts erfolgt auf eigene Verantwortung. Der Autor
bernimmt keine Haftung fr die Richtigkeit und Funktionsfhigkeit des Scripts.
Der Autor haftet weder fr direkte, noch fr indirekte Schden, die durch das
Script entstanden sind. Dies umfasst vor allem, aber nicht ausschlielich,
Schden an der Hardware, am Betriebssystem oder an anderen Programmen, sowie
die Beeintrchtigung des Geschftsbetriebes.


Ausnahmen
---------

Die Erteilung einer Ausnahme von den Bestimmungen dieses Lizenzvertrages
erfordert eine ausdrckliche Genehmigung des Autors, die ggf. per E-Mail
erteilt wird.

Wenn Sie Fragen zur Lizenz haben, oder eine Ausnahmegenhemigung wnschen,
senden Sie bitte eine E-Mail an: <info@gaijin.at>.


Professional Version
--------------------

Einige Funktionen dieses Programms stehen nur in der Professional-Version zur
Verfgung (nur fr ausgewhlte bersetzer und sonstige Personen, die das Script
auf andere Weise untersttzt haben). Fr eventuelle Fragen wenden Sie sich
bitte an <webmaster@gaijin.at>.

Features der Professional Version:
  o) Es kann eine Captcha-Grafik angezeigt oder eine Rechenaufgabe gestellt
     werden, um Spam zu vermeiden.

*/

// ############################################################################

define('INTERN_CALL', '1');

// ############################################################################

// ****************
// *** SETTINGS ***
// ****************

// Language
include_once('language/german.php');
//include_once('language/english.php');

// Page title, e.g. $FormTitle = 'Contact';
$FormTitle = GetLngStr('DefaultFormTitle');

// Your mail address (recipient address)
$RecipientAddress = 'info@teamofpain.de';

// Name of stylesheet (default is "default")
$FormStyle = 'default';

// ############################################################################

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
<head>
<title><?php echo htmlspecialchars($FormTitle); ?></title>

<meta name="title" content="<?php echo htmlspecialchars($FormTitle); ?>">
<meta name="description" content="<?php echo htmlspecialchars($FormTitle); ?>">
<meta name="keywords" content="Contact, contact form, Kontakt, Kontaktformular">
<meta name="author" content="Gaijin.at">
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="<?php echo $FormStyle; ?>.css" type="text/css">
<script language="javascript" type="text/javascript">
	var RecaptchaOptions = { theme : 'white', lang : '<?php echo GetLngStr('ReCaptchaLanguage'); ?>' };
</script>
</head>
<body>

<h1><?php echo $FormTitle; ?></h1>

<?php

$send = GetParam('p_send', 'P');

$from_name = GetParam('g_fromname', 'G');
$from_mail = strtolower(GetParam('g_frommail', 'G'));
$mail_subject = GetParam('g_mailsubject', 'G');
$mail_text = GetParam('g_mailtext', 'G');

$err_text='';

if ($send == '1') {
	$from_name = GetParam('p_fromname', 'P');
	$from_mail = strtolower(GetParam('p_frommail', 'P'));
	$mail_subject = GetParam('p_mailsubject', 'P');
	$mail_text = GetParam('p_mailtext', 'P');
	
	if (trim($from_name) == '') $err_text .= GetLngStr('PostErrNoName').'<br>';
	if (trim($from_mail) == '')
		$err_text .= GetLngStr('PostErrNoMailAddr').'<br>';
	else
		if (!preg_match('/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,6})$/i', $from_mail))
			$err_text .= GetLngStr('PostErrInvalidMailAddr').'<br>';
	if (trim($mail_subject) == '') $err_text .= GetLngStr('PostErrNoSubj').'<br>';
	if (trim($mail_text) == '') $err_text .= GetLngStr('PostErrNoText').'<br>';
}

// *** Zu langen Text abschneiden ***
if (strlen($mail_text) > 1000) {
	$mail_text = substr($mail_text, 0, 1000).GetLngStr('TextCutMark');
}
$from_name = str_replace(chr(34), "''", $from_name);
$mail_subject = str_replace(chr(34), "''", $mail_subject);
$from_name = stripslashes($from_name);
$from_mail = stripslashes($from_mail);
$mail_subject = stripslashes($mail_subject);
$mail_text = stripslashes($mail_text);

if (($send == '1') && ($err_text != '')) {
	echo '<p class="errorbox"><span class="errortitle">'.GetLngStr('PostError').'</span><br>';
	echo ''.$err_text.'</p>';
}

if (($send != '1') || ($err_text != '')) {
?>

<form action="<?php echo GetParam('PHP_SELF','S'); ?>" method="post">
<table border=0 cellspacing=2 cellpadding=0>
<tr><td nowrap align=right><?php echo GetLngStr('PostFormName'); ?></td><td>&nbsp;</td>
<td><input type="text" name="p_fromname" size=50 maxlength=120 value="<?php echo htmlspecialchars($from_name); ?>"></td></tr>
<tr><td nowrap align=right><?php echo GetLngStr('PostFormMail'); ?></td><td></td>
<td><input type="text" name="p_frommail" size=50 maxlength=120 value="<?php echo htmlspecialchars($from_mail); ?>"></td></tr>
<tr><td nowrap align=right><?php echo GetLngStr('PostFormSubj');test ?></td><td></td>
<td><input type="text" name="p_mailsubject" size=50 maxlength=120 value="<?php echo htmlspecialchars($mail_subject); ?>"></td></tr>
<tr><td nowrap align=right valign=top><?php echo GetLngStr('PostFormText'); ?><br><i><?php echo GetLngStr('PostFormTextMax'); ?></i></td><td></td>
<td><textarea cols=45 rows=10 name="p_mailtext"><?php echo htmlspecialchars($mail_text); ?></textarea></td></tr>

<tr><td></td><td></td><td>
<input type="hidden" value="1" name="p_send">
<input type="submit" value="<?php echo GetLngStr('PostFormSubmit'); ?>" name="submit" class="formbutton">

</td></tr>
</table>
</form>

<?php
} else {
  $header  = "From: $from_name <$from_mail>\n";
  $header .= "Reply-To: $from_mail\n";
  $header .= "X-Mailer: PHP-ContactForm-Script\n";
  $header .= "Content-Type: text/plain";
  $mail_date = gmdate('D, d M Y H:i:s').' +0000';
  $send = 0;
  if (@mail($RecipientAddress, $mail_subject, $mail_text, $header))
  {
    echo '<p><b class=green>'.GetLngStr('ResultSuccess').'</b></p>';
    echo '<p><b><a href="'.GetParam('PHP_SELF','S').'?g_fromname='.urlencode(htmlspecialchars($from_name)).'&g_frommail='.urlencode(htmlspecialchars($from_mail)).'">'.GetLngStr('BackToForm').'</a></b></p>';
  } else {
    echo '<p><b class=red>'.GetLngStr('ResultError').'</b></p>';
    echo '<p><b><a href="'.GetParam('PHP_SELF','S').'?g_fromname='.urlencode(htmlspecialchars($from_name)).'&g_frommail='.urlencode(htmlspecialchars($from_mail)).'&g_mailsubject='.urlencode(htmlspecialchars($mail_subject)).'&g_mailtext='.urlencode(htmlspecialchars($mail_text)).'">'.GetLngStr('BackToForm').'</a></b></p>';
  }
}

// Das Entfernen oder Unkenntlichmachen des Links zu www.gaijin.at ist ein
// Versto gegen das Urheberrecht und die Lizenzbestimmungen.

// Fr weitere Fragen sowie fr eine Genehmigung zum Entfernen des Links
// wenden Sie sich bitte an <info@gaijin.at>

echo '<p class=gray><b>PHP ContactForm</b> powered by <b><a href="http://www.gaijin.at/">Gaijin.at</a></b></p>';

// #############################################################################

function GetParam($ParamName, $Method = 'P', $DefaultValue = '')
{
  if ($Method == 'P') {
    if (isset($_POST[$ParamName])) return $_POST[$ParamName]; else return $DefaultValue;
  } else if ($Method == 'G') {
    if (isset($_GET[$ParamName])) return $_GET[$ParamName]; else return $DefaultValue;
  } else if ($Method == 'S') {
    if (isset($_SERVER[$ParamName])) return $_SERVER[$ParamName]; else return $DefaultValue;
  } else if ($Method == 'Z') {
    if (isset($_SESSION[$ParamName])) return $_SESSION[$ParamName]; else return $DefaultValue;
  }
}

// #############################################################################

function GetLngStr($sId, $sParams = '')
{
	global $Lang;
    
	if (isset($Lang[$sId]))
		$sResult = $Lang[$sId];
	else
		$sResult = '{Missing string "'.$sId.'"}';

  $aParams = explode("\t", $sParams);
  for ($i = 0; $i < count($aParams); $i++) {
    $sResult = str_replace('%s'.($i + 1).'%', $aParams[$i], $sResult);
  }
  
  return $sResult; 
}

// #############################################################################

?>

</body>
</html>
