<?php

/**
 * @author Florian Hochriegl, Florian@Hochriegl.de
 * @website www.gamers-congress.de
 * @version 2011033001
 * Admin-Interface fr das Rechnungsmodul
 * erlaubt offene Zahlungen anzuzeigen
 * zeigt Details zu einer offenen Zahlung an
 * kann eine Zahlung freigeben oder verstecken (ist dann nur noch ber die Datenbank einzusehen)
 */
include_once("../../global.php");
include_once($global['script_root'] . "/gc_payment/paymentConstants.php");
include_once($global['script_root'] . "/gc_payment/paymentFunctions.php");


$PAGE->htmltitle = $PAGE->sitetitle = "GC Payment Admininterface";

/**
 * Zeigt eine bersicht ber alle offenen Zahlungen an und bietet die Optionen zum anzeigen, freigeben, lschen
 * @return nothing
 */
function show_active() {

    $myOutput .= "<script type=\"text/javascript\">
      								//<![CDATA[
        							function link(ziel) {
        		  				if(confirm('Bezahlung wirklich freigeben?'))
     			       			top.location.href = ziel;
    			    				}
   		  							//]]>
  				</script>";

    $query = "SELECT gc_payment.ID , amount, userid, vorname, nick, nachname
                FROM gc_payment
                INNER JOIN user ON user.id = gc_payment.userid
                WHERE paid =0
                LIMIT 0 , 30;";
    $result = mysql_query($query) OR die(mysql_error() . "<br>" . $query);

    $myOutput .= '<table border="0" width="100%">
          <tr>
            <td>ID</td>
            <td>Eingericht von</td>
            <td>Flliger Betrag<td>
            <td></td>
          </tr>';

    while ($row = mysql_fetch_object($result)) {

        $myOutput .= '<tr>
              <td>' . $row->ID . '</td>

              <td>' . $row->vorname . ' ' . $row->nick . ' ' . $row->nachname . ';</td>
                  
              <td>' . $row->amount . ' &euro;</td>


              <td>  
                    <a href=./?do=show_details&id=' . $row->ID . '>     <img heigth=32 width=32 src="/images/gc_payment/details.png"></a>
                    <a href="#" onclick="link(\'./?do=activate&id=' . $row->ID . '\');"> <img heigth=32 width=32 src="/images/gc_payment/ok.png"></a>
                    <a href=./?do=hide&id=' . $row->ID . '>         <img heigth=32 width=32 src="/images/gc_payment/hide.png"></a>
              </td>
              </tr>
';
    }

    $myOutput .= '</table>';

    $HTML = new htmlout;
    $myOutput = $HTML->message("Offene Zahlungen", $myOutput);

    return $myOutput;
}

/**
 *
 * @global <int> $id Versteckt einen Rechnungseintrag
 * @return nothing
 */
function hide() {

    global $id;

    $query = "UPDATE gc_payment
         SET paid = 2
         where id = $id;";
    $result = mysql_query($query) OR die(mysql_error() . "<br>" . $query);

    $HTML = new htmlout;
    $myOutput = $HTML->message("o_O", "Zahlung " . $id . " wurde versteckt");

    return $myOutput;
}

/**
 * Zeigt Details zu einem Rechnungseintrag an
 * @global <int> $id        ID der Rechnung
 * @global <array> $options optionen aus der paymentconstants
 * @global <array> $seats   sitze aus der paymentconstants
 * @return nothing
 */
function show_details() {

    global $id;
    global $options;
    global $seats;

    $query = "SELECT * from gc_payment_details where id = $id;";
    $result = mysql_query($query) OR die(mysql_error() . "<br>" . $query);

    while ($row = mysql_fetch_object($result)) {
        $paymentDetail[$row->userid][$row->option] = $row->value;
        $paymentUsers[$row->userid] = 1;
    }

    $query = "SELECT id, nick, vorname, nachname from user
                    WHERE ";
    foreach ($paymentUsers as $userid => $key)
        $query .= "id = " . $userid . " OR ";

    $query .= "id = 'gibtsniemals'";


    $result = mysql_query($query) OR die(mysql_error() . "<br>" . $query);

    while ($row = mysql_fetch_object($result)) {
        $paypal_users_data[$row->id]['vorname'] = $row->vorname;
        $paypal_users_data[$row->id]['nachname'] = $row->nachname;
        $paypal_users_data[$row->id]['nick'] = $row->nick;
    }



    $money_for_all = 0;

    $myOutput .= "Folgende Gebühren wurden ermittelt: <br>";

    $myOutput .= '
        <table border="0" width="100%">';


    foreach ($paymentUsers as $userid => $nothing) {
        $money_for_user = 0;

        $myOutput .= "	<tr>
		<td>" . $paypal_users_data[$userid]['vorname'] . " " . $paypal_users_data[$userid]['nachname'] . " <br>
                    " . $paypal_users_data[$userid]['nick'] . "</td>
		<td>";


        // Sitzplatzkosten
        if ($seats[$paymentDetail[$userid][seat]]['price_style'] == "fixed")
            $price = $seats[$paymentDetail[$userid][seat]]['price'];
        else if ($seats[$paymentDetail[$userid][seat]]['price_style'] == "per_month")
            $price = $seats[$paymentDetail[$userid][seat]]['price'][date("m")];

        $myOutput .= $paymentDetail[$userid]['seat'] . " " . $price . " &euro; <br>";


        $money_for_user += $price;


        // Optionskosten
        foreach ($options as $optionname => $option) {
            if (isset($paymentDetail[$userid][$optionname]) || $option['required'] == true) {

                if ($option['price_style'] == "additional")
                    $price = $option['price'];
                else if ($option['price_style'] == "percent")
                    $price = $money_for_user * $option['price'];
                else
                    $price = 666;

                $myOutput .= $optionname . " " . $price . " &euro;<br>";
                $money_for_user += $price;
            }
        }

        $myOutput .= "<br>Kosten für User: " . $money_for_user . "<br>";
        $money_for_all += $money_for_user;
        $myOutput .= "</td>
	</tr>

        <tr><td colspan=2>--------------------------------------------------------------------------------------------------</td></tr>
";
    }



    $myOutput .= '
            </table>';

    $myOutput .= "Gesamtkosten: " . number_format($money_for_all, 2) . " &euro; <br>";


    $myOutput .= "<script type=\"text/javascript\">
      								//<![CDATA[
        							function link(ziel) {
        		  				if(confirm('Bezahlung wirklich freigeben?'))
     			       			top.location.href = ziel;
    			    				}
   		  							//]]>
  				</script>";


    $myOutput .= '<div align="center">
        <a href="#" onClick="history.back()"><img heigth=32 width=32 src="/images/gc_payment/back.png"></a> 
        <a href="#" onclick="link(\'./?do=activate&id=' . $id . '\');"> <img heigth=32 width=32 src="/images/gc_payment/ok.png"></a>
        <a href=./?do=hide&id=' . $id . '><img heigth=32 width=32 src="/images/gc_payment/hide.png"></a>
        

                        </div>';



    $HTML = new htmlout;
    $myOutput = $HTML->message("Details fr Rechnung" . $id, $myOutput);

    return $myOutput;
}

/**
 * Aktiviert eine Zahlung
 * @global  $id     ID des Rechnungseintrages
 * @return nothing
 */
function activate() {
    global $id;
    activateByID($id);

    $HTML = new htmlout;
    $myOutput = $HTML->message("o_O", "Zahlung " . $id . " freigegeben");

    return $myOutput;
}


// HTML Output
if ($ADMIN->check(IS_ADMIN)) {
    $do = $_GET['do'];
    if (!isset($do))
        $do = "show_active";

    if ($do == "show_active") {
        $myOutput = show_active();
    }

    if ($do == "show_details") {
        $myOutput = show_details();
    }

    if ($do == "activate") {
        $myOutput = activate();
        $myOutput .= "<br>";
        $myOutput .= show_active();
    }

    if ($do == "hide") {
        $myOutput = hide();
        $myOutput .= "<br>";
        $myOutput .= show_active();
    }



    $output = $myOutput;
    $PAGE->render($output);
}
?>
