<?
##############################################################
#                                                            #
#    Teilnehmer-Grafik-Tool                                  #
#    2006 Michael Meschenmoser - fr LANbada Convention      #
#    Erweitert und modifiziert um Monatsmodus von            #
#    Tobias Mller Mitten aus Deutschaln e.V.                #
#    (http://tn.lanverein.de)                                #
#    Version 2006-03-06-1645                                 #
#                                                            #
##############################################################


#################
# Konfiguration #
#################

// Das .LAN includen
include("../global.php");

$PAGE -> htmltitle = "Teilnehmerstatistiken";	// Browserfenstertietel
$PAGE -> sitetitle = "Teilnehmerstatistiken";	// Seitentietel

$standardmode = 1;	//Der Modus der angeziegt wird, wenn keiner ausgewhlt ist. 1 == Monatlich 2 == fortlaufend
$step = 86400;   	// nach welchem Zeitraum (in Sekunden) soll eine neue Zeile kommen, empfohlen 1Tag = 86400
$maxheight = 300; 	// Die Maximale hhe einer Monatsdarstellung in Pixeln. Die Hhe der Balken wird danach berechnet
$maxwidth = 350; 	// Die Maximale Breite der durchlaufenden Ansicht in Pixeln. Die Lnge der Balken wird danach berechnet

#################
#################

// Event-ID
$eventid = $id;

$EVENT->getevent($eventid); //Event laden

$anfang = $EVENT->eventarr['sgbegin']; // Eventbeginn

$laufer = $anfang; //Hilfsvariable

$jetzt = time();

$buf = date("m", $anfang);
$start = FALSE;

$mode = (!isset($mode))?$standardmode:$mode;
if($mode == 1)
{
  $output .= "<div style=\"width: 360px; margin: 0px 0px 0px 75px;\">";
  
  $action = $DB -> query("SELECT user_id FROM event_teilnehmer WHERE event_id = ".$eventid);
  $all = $DB->num_rows($action);
    
  while ( $laufer < $jetzt )
  {
    $date = $laufer + $step;
    
    if($start === FALSE)
    {
      $output .= '<table height="'.$maxheight.'" border=0 cellspacing=1 cellpadding=0><tr>'."\n";
      $output .= '<strong>'.date("F", $laufer).' '.date("Y", $laufer).'</strong><br />';
      $start = TRUE;
    }
     
    $befehl = "SELECT * FROM event_teilnehmer WHERE event_id=".$eventid." AND bezahlt < 2 AND joinevent > ".$laufer." AND joinevent < ".$date;
    $res = $DB->query($befehl);
    $angemeldet = $DB->num_rows($res);
    
    $befehl1 = "SELECT * FROM event_teilnehmer WHERE event_id=".$eventid." AND bezahlt = 1 AND payday > ".$laufer." AND payday < ".$date;
    $res1 = $DB->query($befehl1);
    $bezahlt = $DB->num_rows($res1);
    
    $gcount += $angemeldet;
    $bezall += $bezahlt;
    $redcount = ($bezall + ($gcount-$bezall)) - $EVENT -> eventarr['anzahl'];
    $yecount = ($redcount < 1)?($gcount-$bezall):($gcount-$bezall) - $redcount;
    
    $faktor = $maxheight / $all;
    $greenh = $faktor * $bezall;
    $yellowh = $faktor * $yecount;
    $redh = $faktor * $redcount;
    
    $output .= ' <td style="width: 10;" valign="bottom" bgcolor="#EEEEEE" align="center">'."\n";
    $output .= '  <table width=8 border=0 cellspacing=0 cellpadding=0>'."\n";
    $output .= "   <tr><td valign=\"bottom\">".(($redcount > 0)?"<img src=reddot.gif height=".$redh." title=\"berhang: ".$redcount."\" width=8>":"")."</td></tr>\n"; // rot
    $output .= "   <tr><td valign=\"bottom\"><img src=yellowdot.gif height=".$yellowh." title=\"nicht bezahlt: ".$yecount."\" width=\"8\"></td></tr>\n"; // gelb
    $output .= "   <tr><td valign=\"bottom\">".(($bezall > 0)?"<img src=greendot.gif height=".$greenh." title=\"bezahlt: ".$bezall." (heute neu: ".$bezahlt.")\" width=8":"")."</tn></tr>\n"; // gruen
    $output .= "   <tr><td valign=\"bottom\" bgcolor=\"#000000\"><font color=\"#FFFFFF\">".date("d", $laufer)."</font></td></tr>\n"; 
    $output .= '  </table>'."\n";
    $output .= ' </td>'."\n";
      
    if(date("m", $date) != $buf)
    {
      $output .= '</tr></table><br /><br />';
      $start = FALSE;
    }
    $laufer += $step;
    $buf = date("m", $laufer);
  }
  if($start === TRUE) $output .= '</tr></table><br /><br />';
  $output .= "</div>";
}

if($mode == 2)
{
  $output .= "<table width=100% cellpadding=0 cellspacing=0><tr><td>Datum<td colspan=2>Teilnehmer<td>Grafik</tr><tr><td><td><i>neue</i><td><i>gesamte</i><td></tr>";
  
  $action = $DB -> query("SELECT user_id FROM event_teilnehmer WHERE event_id = ".$eventid);
  $all = $DB->num_rows($action);
   
  while ( $laufer < $jetzt )
  {
    $date = $laufer + $step;
    if($start === FALSE)
    {
      $output .= '<tr><td><strong>'.date("F", $laufer).' '.date("Y", $laufer).'</strong></td></tr>';
      $start = TRUE;
    }
  
    $laufer2 = $laufer+$step;
    $befehl = "SELECT * FROM event_teilnehmer WHERE event_id=".$eventid." AND bezahlt < 2 AND joinevent > ".$laufer." AND joinevent < ".$laufer2;
    $res = $DB->query($befehl);
    $angemeldet = $DB->num_rows($res);
    
    $befehl1 = "SELECT * FROM event_teilnehmer WHERE event_id=".$eventid." AND bezahlt = 1 AND payday > ".$laufer." AND payday < ".$laufer2;
    $res1 = $DB->query($befehl1);
    $bezahlt = $DB->num_rows($res1);
    
    $output .= "<tr>\n<td>".date('d.m.y', $laufer)."</td>";
    $laufer = $laufer+$step;
    
    $gcount += $angemeldet;
    $bezall += $bezahlt;
    $redcount = ($bezall + ($gcount-$bezall)) - $EVENT -> eventarr['anzahl'];
    $yecount = ($redcount < 1)?($gcount-$bezall):($gcount-$bezall) - $redcount;
    
    $faktor = $maxwidth / $all;
    $greenw = $faktor * $bezall;
    $yelloww = $faktor * $yecount;
    $redw = $faktor * $redcount;
    $output .= "<td>".$count."</td><td>".$gcount."</td><td>".(($bezall > 0)?"<img src=greendot.gif height=3 title=\"bezahlt: ".$bezall." (heute neu: ".$bezahlt.")\" width=".$greenw.">":"")."<img src=yellowdot.gif height=3 title=\"nicht bezahlt: ".$yecount."\" width=".$yelloww.">".(($redcount > 0)?"<img src=reddot.gif height=3 title=\"berhang: ".$redcount."\" width=".$redw.">":"")."</tr>";
  
    if(date("m", $date) != $buf)
    {
      $start = FALSE;
    }
    $buf = date("m", $laufer);
  }
  $output .= "</table>";
}

$zeitraum = $jetzt - $anfang; //Unixzeit von Anfang der Anmeldung bis jetzt ausrechnen
$tage = floor($zeitraum/86400); // Anzahl der Tage aus der Uniczeit errechnen
$protag = $gcount/$tage; // Anzahl der Anmeldungen pro Tag bis jetzt errechnen
$bprotag = $bezall/$tage; // Anzahl der Bezahler pro Tag bis jetzt errechnen

$beginn = $EVENT->eventarr['begin_ts']; // Eventbeginn
$nochzeit = $beginn - $jetzt; // Unixzeit von jetzt bis zum Eventbeginn
$resttage = floor($nochzeit/86400); // Tage von jetzt bis zum Eventbeginn errechnen
$hochrechnung = floor($resttage*$protag) + $gcount; // Hochrechnen der Anmeldungen bis zu Beginn (abgerundet)
$hochrechnungbezahler = floor($resttage*$bprotag) + $bezall; // Hochrechnen der Bezahler bis Beginn (abgerundet)

$output .= "<br /><strong>Hochrechnung ". $hochrechnung ." angemeldete Teilnehmer und ".$hochrechnungbezahler." Bezahler</strong>";


// Die Seite erstellen

$PAGE->render($output);

?>